
#ifndef CE2_RC4_H
#define CE2_RC4_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CE2_public.h"

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object % CE2_RC4.h    : %
   *  State           :  %state%
   *  Creation date   :  Wed Nov 17 16:42:30 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief This file contains all of the enums and definitions that are used for the 
   *         CE2 RC4 APIs, as well as the APIs themselves. 
   *
   *  \version CE2_RC4.h#1:incl:1
   *  \author adams
   *  \remarks Copyright (C) 2005 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************************ Defines ******************************/

/** 
@brief - This module defines the interface to the RC4 cryptographic support
*/

#define CE2_RC4_S_BOX_SIZE_IN_BYTES 256
#define CE2_RC4_MAX_KEY_SIZE_IN_BYTES 256

/************************ Public Variables **********************/


/************************ Public Functions **********************/

/**
****************************************************************
* Function Name: 
*  CE2_RC4
*
*  @param Key_ptr [in] - A pointer to the user's key buffer.
*  @param KeySizeInBytes [in] - The size of the KEY in bytes.
*  @param DataIn_ptr [in] - The pointer to the buffer of the input data to the RC4. 
*                   The pointer's value does not need to be word-aligned.
*  @param DataInSize [in] - The size of the input data.
*  @param DataOut_ptr [in/out] The pointer to the buffer of the output data from the RC4.
*                The pointer's value does not need to be word-aligned. 
*                The size of this buffer must be the same as the DataIn buffer.  
*
* @returns \b
*  CE2Error_t 
*  - CE2_OK - on success
*  - Otherwise - error code:
*   - CE2_RC4_INVALID_USER_CONTEXT_POINTER_ERROR,
*   - CE2_RC4_USER_CONTEXT_CORRUPTED_ERROR
*
* \brief \b 
* Description:
*  This function provides a RC4 function for processing data.
*
*  The function allocates an internal RC4 Context, and initializes the RC4 Context with the
*  cryptographic attributes that are needed for the RC4 cryptographic operation. Next the
*  function loads the engine with the initializing values, and then processes the data,
*  returning the processed data in the output buffer. Finally, the function frees the
*  internally allocated context.
*
*  \b 
* Algorithm:
*  -# Verify input parameters for validity;
*  -# Call low level function LLF_RC4 
*     for AES with using LibTomCrypt.
***************************************************************/
CE2CIMPORT_C CE2Error_t CE2_RC4  (DxUint8_t 				      *Key_ptr, 
                  	   DxUint32_t 				   KeySizeInBytes,
                       DxUint8_t                    *DataIn_ptr,                                  
                       DxUint32_t                    DataInSize,
                       DxUint8_t                    *DataOut_ptr);  

#ifdef __cplusplus
}
#endif

#endif
